<?php
$business_shuffle_slider_disable = get_theme_mod('business_shuffle_slider_disable', 'off');
if ($business_shuffle_slider_disable != 'on') {
    ?>
    <div id="bs-slider-section">
        <?php
        $slider1 = get_theme_mod('business_shuffle_slider_1');
        $slider2 = get_theme_mod('business_shuffle_slider_2');
        $slider3 = get_theme_mod('business_shuffle_slider_3');
        $slider4 = get_theme_mod('business_shuffle_slider_4');
        $sliders = array($slider1, $slider2, $slider3, $slider4);

        $business_shuffle_slider_full_screen = get_theme_mod('business_shuffle_slider_full_screen', false);
        $slider_class = $business_shuffle_slider_full_screen ? 'bs-full-screen' : '';
        $slider_arrow = get_theme_mod('business_shuffle_slider_arrow');
        $slider_arrow = $slider_arrow ? 'true' : 'false';
        $slider_dots = get_theme_mod('business_shuffle_slider_dots');
        $slider_dots = $slider_dots ? 'true' : 'false';
        $slider_pause = get_theme_mod('business_shuffle_slider_pause', 6);
        ?>
        <div class="bs-main-slider owl-carousel <?php echo esc_attr($slider_class); ?>" data-arrow="<?php echo esc_attr($slider_arrow) ?>"  data-dots="<?php echo esc_attr($slider_dots) ?>" data-pause="<?php echo esc_attr($slider_pause) ?>" >
            <?php
            $sliders = array_filter($sliders);

            if (is_array($sliders)) {
                foreach ($sliders as $slider) {
                    $query = new WP_Query(array(
                        'page_id' => absint($slider)
                    ));

                    if ($query->have_posts()) {
                        while ($query->have_posts()) {
                            $query->the_post();
                            if (has_post_thumbnail()) {
                                $image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
                                ?>
                                <div class="bs-slides">
                                    <img src="<?php echo esc_url($image[0]) ?>"/>
                                    <div class="bs-slider-caption-wrap">
                                        <div class="bs-container">
                                            <div class="bs-slider-caption">
                                                <div class="bs-slider-caption-title">
                                                    <?php the_title(); ?>
                                                </div>

                                                <div class="bs-slider-caption-subtitle">
                                                    <?php the_content(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                }
                            }
                            ?>

                        </div>
                        <?php
                    }
                    wp_reset_postdata();
                }
            }
            ?>
        </div>
    </div>
<?php
}