<?php
$business_shuffle_progressbar_section_disable = get_theme_mod('business_shuffle_progressbar_section_disable', 'off');
if ($business_shuffle_progressbar_section_disable != 'on') {
    $business_shuffle_left_block_image = get_theme_mod('business_shuffle_left_block_image');
    ?>
    <div id="progressbar-section">
        <div class="progress-bar-left-bg" style="background-image:url(<?php echo $business_shuffle_left_block_image; ?>)"></div>
        <div class="bs-container">
        <div class="progressbar-left-block">
            <?php
            $business_shuffle_progressbar_left_block_page = get_theme_mod('business_shuffle_progressbar_left_block_page');

            if ($business_shuffle_progressbar_left_block_page) {
                $query = new WP_Query(array(
                    'page_id' => absint($business_shuffle_progressbar_left_block_page)
                ));

                if ($query->have_posts()) {
                    while ($query->have_posts()) {
                        $query->the_post();
                        ?>

                        <div class="progressbar-content">
                            <h3 class="section-title"><?php the_title(); ?></h3>
                            <?php the_content(); ?>
                        </div>
                        <?php
                    }
                }
            }
            wp_reset_postdata();
            ?> 
        </div>

        <div class="progressbar-right-block">
            <div class="progressbar-content">
                <?php
                $business_shuffle_progressbar_heading = get_theme_mod('business_shuffle_progressbar_heading');
                $business_shuffle_progressbar_sub_heading = get_theme_mod('business_shuffle_progressbar_sub_heading');

                if (!empty($business_shuffle_progressbar_heading)) {
                    ?>
                    <h3 class="section-title"><?php echo esc_html($business_shuffle_progressbar_heading); ?></h3>
                    <?php
                }

                if (!empty($business_shuffle_progressbar_sub_heading)) {
                    ?>
                    <div class="section-subtitle"><?php echo esc_html($business_shuffle_progressbar_sub_heading); ?></div>
                    <?php
                }
                ?>

                <div class="bs-progress-bars">
                    <?php
                    for ($i = 1; $i < 5; $i++) {
                        $business_shuffle_progressbar_title = get_theme_mod('business_shuffle_progressbar_title_' . $i);
                        $business_shuffle_progressbar_counter = get_theme_mod('business_shuffle_progressbar_counter_' . $i, 80);
                        if (!empty($business_shuffle_progressbar_title)) {
                            ?>
                            <div class="bs-progress">
                                <div class="bs-progress-title"><?php echo esc_html($business_shuffle_progressbar_title); ?></div>
                                <div class="bs-progress-bar" data-width="<?php echo absint($business_shuffle_progressbar_counter); ?>">
                                    <div class="bs-progress-bar-length">
                                        <span><?php echo absint($business_shuffle_progressbar_counter) . "%"; ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div>
        </div>
        </div>
    </div>
<?php }
