<?php
$business_shuffle_highlight_section_disable = get_theme_mod('business_shuffle_highlight_section_disable', 'off');
if ($business_shuffle_highlight_section_disable != 'on') {
    ?>
    <div id="highlight-section">
        <div class="highlight-section-wrap">
            <?php
            for ($i = 1; $i < 4; $i++) {
                $business_shuffle_highlight_icon = get_theme_mod('business_shuffle_highlight_icon_' . $i, 'fas fa-address-book');
                $business_shuffle_highlight_title = get_theme_mod('business_shuffle_highlight_title_' . $i);
                $business_shuffle_highlight_link = get_theme_mod('business_shuffle_highlight_link_' . $i);
                $business_shuffle_highlight_bg = get_theme_mod('business_shuffle_highlight_bg_' . $i);
                ?>
                <div class="highlight-block" style="background-image:url(<?php
                echo esc_url
                        ($business_shuffle_highlight_bg);
                ?>)">
                    <div class="highlight-block-content">
                        <i class="<?php echo esc_attr($business_shuffle_highlight_icon); ?>"></i>
                        <div class="highlight-title"><?php echo esc_html($business_shuffle_highlight_title); ?></div>

                        <?php
                        if ($business_shuffle_highlight_link) {
                            ?>
                            <a href="<?php echo esc_url($business_shuffle_highlight_link) ?>"><?php echo esc_html__('More', 'business-shuffle') ?></a>
                            <?php
                        }
                        ?>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
    </div>
    <?php
}
