<?php
$business_shuffle_featured_section_disable = get_theme_mod('business_shuffle_featured_section_disable', 'off');
if ($business_shuffle_featured_section_disable != 'on') {
    $business_shuffle_featured_col = get_theme_mod('business_shuffle_featured_col', 3);
    $business_shuffle_featured_link_to_detail = get_theme_mod('business_shuffle_featured_link_to_detail', false);
    ?>
    <div id="featured-section">
        <div class="bs-container">
            <div class="featured-section-wrap bs-col-<?php echo esc_attr(absint($business_shuffle_featured_col)) ?>" >
                <?php
                $business_shuffle_featured_title = get_theme_mod('business_shuffle_featured_title');

                if (!empty($business_shuffle_featured_title)) {
                    ?>
                    <h3 class="section-title section-title-center"><?php echo esc_html($business_shuffle_featured_title); ?></h3>


                    <div class="featured-block-wrap">
                        <?php
                    }
                    for ($i = 1; $i < 7; $i++) {
                        $business_shuffle_featured_icon = get_theme_mod('business_shuffle_featured_icon_' . $i, 'fas fa-address-book');
                        $business_shuffle_featured = get_theme_mod('business_shuffle_featured_' . $i);
                        if ($business_shuffle_featured) {
                            ?>
                            <div class="featured-item">
                                <div class="featured-icon-holder">
                                    <i class="<?php echo esc_attr($business_shuffle_featured_icon); ?>"></i>
                                </div>
                                <div class="featured-info-box">
                                    <?php
                                    $query = new WP_Query(array(
                                        'page_id' => absint($business_shuffle_featured)
                                    ));

                                    if ($query->have_posts()) {
                                        while ($query->have_posts()) {
                                            $query->the_post();
                                            ?>
                                            <h5 class="featured-title"><?php the_title(); ?></h5>

                                            <div class="featured-content">
                                                <?php
                                                if (has_excerpt() && '' != trim(get_the_excerpt())) {
                                                    the_excerpt();
                                                } else {
                                                    echo business_shuffle_excerpt(get_the_content(), 100);
                                                }
                                                ?>
                                            </div>
                                            <?php
                                            if ($business_shuffle_featured_link_to_detail) {
                                                ?>
                                                <a class="featured-read-more" href="<?php the_permalink(); ?>"><?php echo esc_html__('More', 'business-shuffle') ?></a>
                                                <?php
                                            }
                                        }
                                    }
                                    wp_reset_postdata();
                                    ?>
                                </div>
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    <?php
}