<?php
$business_shuffle_counter_section_disable = get_theme_mod('business_shuffle_counter_section_disable', 'off');
if ($business_shuffle_counter_section_disable != 'on') {
    $business_shuffle_counter_col = get_theme_mod('business_shuffle_counter_col', 4);
    ?>
    <div id="counter-section" class="counter-stats">
        <div class="bs-container">
            <?php
            $business_shuffle_counter_title = get_theme_mod('business_shuffle_counter_title', esc_html__('Our Stats','business-shuffle'));

            if (!empty($business_shuffle_counter_title)) {
                ?>
                <h3 class="section-title section-title-center"><?php echo esc_html($business_shuffle_counter_title); ?></h3>
                <?php
            }
            ?>

            <div class="counter-section-wrap bs-col-<?php echo esc_attr(absint($business_shuffle_counter_col)); ?>">
                <?php
                for ($i = 1; $i < 5; $i++) {
                    $business_shuffle_counter_icon = get_theme_mod('business_shuffle_counter_icon_' . $i, 'fas fa-address-book');
                    $business_shuffle_counter_title = get_theme_mod('business_shuffle_counter_title_' . $i);
                    $business_shuffle_counter = get_theme_mod('business_shuffle_counter_' . $i);

                    if (!empty($business_shuffle_counter)) {
                        ?>
                        <div class="counter-block">
                            <i class="<?php echo esc_attr($business_shuffle_counter_icon) ?>"></i>
                            <div class="counter-digit counter-value" data-count="<?php echo absint($business_shuffle_counter); ?>">
                                0
                            </div>
                            <?php if ($business_shuffle_counter_title) { ?>
                                <h5><?php echo esc_html($business_shuffle_counter_title); ?></h5>
                            <?php }
                            ?>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </div>
    </div>
    <?php
}