<?php
$business_shuffle_blog_section_disable = get_theme_mod('business_shuffle_blog_section_disable', 'off');
if ($business_shuffle_blog_section_disable != 'on') {
    ?>
    <div id="blog-section">
        <div class="bs-container">
            <?php
            $business_shuffle_blog_title = get_theme_mod('business_shuffle_blog_title', esc_html__('Latest News', 'business-shuffle'));
            if ($business_shuffle_blog_title) {
                ?>
                <h3 class="section-title section-title-center">
                    <?php echo esc_html($business_shuffle_blog_title); ?>
                </h3>
            <?php }
            ?>

            <div class="blog-wrap">
                <?php
                $business_shuffle_blog_cat_exclude = get_theme_mod('business_shuffle_blog_cat_exclude');
                $business_shuffle_blog_cat_exclude = explode(',', $business_shuffle_blog_cat_exclude);

                $args = array(
                    'posts_per_page' => 3,
                    'category__not_in' => $business_shuffle_blog_cat_exclude
                );
                $query = new WP_Query($args);
                if ($query->have_posts()):
                    ?>
                    <div class="bs-big-blog-wrap">
                        <?php
                        while ($query->have_posts()) : $query->the_post();
                            $business_shuffle_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'business-shuffle-400x400');
                            ?>
                            <div class="bs-blog-post">
                                <?php
                                if (has_post_thumbnail()) {
                                    $business_shuffle_image_url = $business_shuffle_image[0];
                                } else {
                                    $business_shuffle_image_url = get_template_directory_uri() . '/img/blog-big-thumb,jpg';
                                }
                                ?> 
                                <div class="bs-blog-thumbnail">
                                    <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($business_shuffle_image_url) ?>" alt="<?php esc_attr(get_the_title()); ?>">

                                        <div class="bs-blog-excerpt">
                                            <div class="bs-blog-date"><?php echo get_the_date(); ?></div>
                                            <h5><?php the_title(); ?></h5>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <?php
                        endwhile;
                        ?>
                    </div>
                    <?php
                endif;
                wp_reset_postdata();
                ?>
            </div>	
        </div>
    </div>
    <?php
}