<?php
$business_shuffle_about_page_disable = get_theme_mod('business_shuffle_about_page_disable', 'off');
if ($business_shuffle_about_page_disable != 'on') {
    ?>
    <div id="about-section">
        <div class="bs-container">
            <div class="about-section-wrap">
                <?php
                $business_shuffle_disable_about_sidebar = get_theme_mod('business_shuffle_disable_about_sidebar', 'off');
                $about_left_content_class = $business_shuffle_disable_about_sidebar == 'on' ? 'full-width' : '';
                ?>
                <div class="about-left-content <?php echo esc_attr($about_left_content_class); ?>">
                    <?php
                    $business_shuffle_about_page = get_theme_mod('business_shuffle_about_page');


                    if ($business_shuffle_about_page) {
                        $query = new WP_Query(array(
                            'page_id' => absint($business_shuffle_about_page)
                        ));

                        if ($query->have_posts()) {
                            while ($query->have_posts()) {
                                $query->the_post();
                                ?>
                                <h3><?php the_title(); ?></h3>
                                <div class="about-content">
                                    <?php the_content(); ?>
                                </div>
                                <?php
                            }
                        }
                    }
                    wp_reset_postdata();
                    ?>
                </div>

                <?php
                if ($business_shuffle_disable_about_sidebar != 'on') {
                    $business_shuffle_about_sidebar = get_theme_mod('business_shuffle_about_sidebar', 'single-image');
                    $business_shuffle_about_image = get_theme_mod('business_shuffle_about_image');
                    ?>
                    <div class="about-right-content">
                        <?php
                        if ($business_shuffle_about_sidebar == 'single-image' && !empty($business_shuffle_about_image)) {
                            ?>
                            <img src="<?php echo esc_url($business_shuffle_about_image); ?>"/>
                            <?php
                        } else {
                            $business_shuffle_about_widget = get_theme_mod('business_shuffle_about_widget');
                            if ($business_shuffle_about_widget) {
                                dynamic_sidebar($business_shuffle_about_widget);
                            }
                        }
                        ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } 
