<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Business_Shuffle
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php if (has_post_thumbnail()) { ?>
        <div class="entry-thumbnail">
            <?php
            $business_shuffle_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'business-shuffle-400x400');
            ?>
            <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($business_shuffle_image[0]); ?>" alt="<?php esc_attr(get_the_title()) ?>" /></a>
        </div>
    <?php } ?>

    <div class="entry-content-wrap">
        <header class="entry-header">
            <?php
            if ('post' === get_post_type()) :
                ?>
                <div class="entry-meta">
                    <?php
                    business_shuffle_posted_on();
                    ?>
                </div><!-- .entry-meta -->
                <?php
            endif;
            the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
            ?>
        </header><!-- .entry-header -->

        <div class="entry-content">
            <?php
            echo esc_html(wp_trim_words(get_the_content(), 45)) . '...';
            ?>
        </div><!-- .entry-content -->

        <div class="entry-readmore">
            <a href="<?php the_permalink(); ?>"><?php echo esc_html__('Read More', 'business-shuffle'); ?></a>
        </div>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->
