<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Business_Shuffle
 */
get_header();
?>
<div class="page-banner">
    <div class="bs-container">
        <div class="page-title">
            <h1><?php
/* translators: %s: search query. */
printf(esc_html__('Search Results for: %s', 'business-shuffle'), '<span>' . get_search_query() . '</span>');
?>
            </h1>
        </div>
    </div>
</div>

<div class="bs-container">
    <div id="primary" class="content-area">

        <?php if (have_posts()) : ?>

            <?php
            /* Start the Loop */
            while (have_posts()) :
                the_post();

                /**
                 * Run the loop for the search to output the results.
                 * If you want to overload this in a child theme then include a file
                 * called content-search.php and that will be used instead.
                 */
                get_template_part('template-parts/content', 'search');

            endwhile;

            the_posts_navigation();

        else :

            get_template_part('template-parts/content', 'none');

        endif;
        ?>
    </div><!-- #primary -->    
    <?php get_sidebar(); ?>

</div>

<?php
get_footer();
