jQuery(function($){
    
    var sf = $('.bs-menu > ul').superfish({
        delay:       500,                            // one second delay on mouseout
        animation:   {opacity:'show',height:'show'},  // fade-in and slide-down animation
        speed:       'fast',                          // faster animation speed
    });

    $(window).resize(function(){
        if($(window).width() < 1000){
            sf.superfish('destroy');
            $('.bs-dropdown').removeClass('bs-opened');
        }else{
            sf.superfish('init');
        }
    }).resize();
    
    $('.menu-item-has-children > a').append('<span class="bs-dropdown"></span>');

    $('.bs-dropdown').on('click', function(){
        $(this).parent('a').next('ul').slideToggle();
        $(this).toggleClass('bs-opened');
        return false;
    })

    $('.toggle-menu').on('click', function(){
        $('.bs-menu').slideToggle();
    });
    
    $('.menu-item-search').on('click', function(){
        $('.bs-header-search-form').toggleClass('bs-show-search-form');
    });
    
    $('.bs-header-close').on('click', function(){
        $('.bs-header-search-form').removeClass('bs-show-search-form');
    });
    
    
    if($('.bs-main-slider').length > 0){
        $('.bs-main-slider').owlCarousel({
            items:1,
            autoplay: true,
            loop:true,
            nav:JSON.parse($('.bs-main-slider').data('arrow')),
            dots:JSON.parse($('.bs-main-slider').data('dots')),
            autoplayTimeout: parseInt($('.bs-main-slider').data('pause'))*1000,
            navText: ['<i class="fas fa-chevron-left"></i>', '<i class="fas fa-chevron-right"></i>']
        });
    }
    
    $(".client-logo-slider").owlCarousel({
        autoplay : true,
        items : 5,
        loop : true,
        nav: false,
        dots : false,
            autoplayTimeout : 7000,
        responsive : {
          0 : {
              items : 2,
          },
          768 : {
              items : 3,
          },
          979 : {
              items : 4,
          },
          1200 : {
              items : 5,
          }
        }   
    });
    
    $('.bs-progress-bar').each(function (index) {
        var $this = $(this);
        var delay_time = parseInt(index * 100 + 300);
        $this.waypoint(function () {
            setTimeout(function () {
                $this.find('.bs-progress-bar-length').animate({
                    width: $this.attr("data-width") + '%'
                }, 1000, function () {
                    $this.find("span").animate({
                        opacity: 1
                    }, 500);
                });
            }, delay_time);
            this.destroy();
        }, {
            offset: '90%',
        });
    });

    //Sticky Header
    $(window).scroll(function () {
        var headerHeight = $('.site-header').outerHeight();
        if($(window).scrollTop() > headerHeight){
            $('.bs-site-header').addClass('sticky');
        } else{
            $('.bs-site-header').removeClass('sticky');
        }
    });


    //Stats
    function statCount() {
        if($('#counter-section').length > 0){
            var a = 0;
            $(window).scroll(function() {
                var oTop = $('#counter-section').offset().top - window.innerHeight;
                if (a == 0 && $(window).scrollTop() > oTop) {
                    $('.counter-value').each(function() {
                        var $this = $(this),
                            countTo = $this.attr('data-count');
                        $({
                            countNum: $this.text()
                        }).animate({
                                countNum: countTo
                            },

                            {
                                duration: 2000,
                                easing: 'swing',
                                step: function() {
                                    $this.text(Math.floor(this.countNum));
                                },
                                complete: function() {
                                    $this.text(this.countNum);
                                }

                            });
                    });

                    a = 1;
                }

            });
    }
    }
    //init count
    statCount();

});

