<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Business_Shuffle
 */
get_header();

if (is_home() && 'page' == get_option('show_on_front')) {
    $blog_page_id = get_option('page_for_posts');
    $blog_title = get_the_title($blog_page_id);
} else {
    $blog_title = esc_html__('Blog', 'business-shuffle');
}
?>

<div class="page-banner">
    <div class="bs-container">
        <div class="page-title">
            <h1><?php echo esc_html($blog_title); ?></h1>
        </div>
    </div>
</div>


<div class="bs-container">
    <div id="primary" class="content-area">

        <?php
        if (have_posts()) :

            /* Start the Loop */
            while (have_posts()) :
                the_post();

                /*
                 * Include the Post-Type-specific template for the content.
                 * If you want to override this in a child theme, then include a file
                 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
                 */
                get_template_part('template-parts/content', get_post_type());

            endwhile;

            the_posts_pagination();

        else :

            get_template_part('template-parts/content', 'none');

        endif;
        ?>
    </div><!-- #primary -->

    <?php get_sidebar(); ?>

</div>

<?php
get_footer();
