<?php
/**
 * @package Business Shuffle
 */
add_action('widgets_init', 'business_shuffle_register_personal_info');

function business_shuffle_register_personal_info() {
    register_widget('business_shuffle_personal_info');
}

class business_shuffle_Personal_Info extends WP_Widget {

    public function __construct() {
        parent::__construct(
                'business_shuffle_personal_info', esc_html__('Business Shuffle - Personal Info', 'business-shuffle'), array(
            'description' => esc_html__('A widget to display Personal Information', 'business-shuffle')
                )
        );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {
        $fields = array(
            'title' => array(
                'business_shuffle_widgets_name' => 'title',
                'business_shuffle_widgets_title' => esc_html__('Title', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'text',
            ),
            'image' => array(
                'business_shuffle_widgets_name' => 'image',
                'business_shuffle_widgets_title' => esc_html__('Image', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'upload',
            ),
            'intro' => array(
                'business_shuffle_widgets_name' => 'intro',
                'business_shuffle_widgets_title' => esc_html__('Short Intro', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'textarea',
                'business_shuffle_widgets_row' => '4'
            ),
            'signature' => array(
                'business_shuffle_widgets_name' => 'name',
                'business_shuffle_widgets_title' => esc_html__('Name', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'text',
            )
        );

        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance) {
        extract($args);

        $title = isset($instance['title']) ? $instance['title'] : '';
        $image = isset($instance['image']) ? $instance['image'] : '';
        $intro = isset($instance['intro']) ? $instance['intro'] : '';
        $name = isset($instance['name']) ? $instance['name'] : '';


        echo $before_widget;  // WPCS: XSS OK.
        ?>
        <div class="bs-personal-info">
            <?php
            if (!empty($title)):
                echo $before_title . esc_html($title) . $after_title;  // WPCS: XSS OK.
            endif;

            if (!empty($image)):
                $image_id = attachment_url_to_postid($image);
                $image_src = wp_get_attachment_image_src($image_id, 'thumbnail');

                echo '<div class="bs-pi-image"><img src="' . esc_url($image_src[0]) . '"/></div>';
            endif;

            if (!empty($name)):
                echo '<h5 class="bs-pi-name"><span>' . esc_html($name) . '</span></h5>';
            endif;

            if (!empty($intro)):
                echo '<div class="bs-pi-intro">' . wp_kses_post($intro) . '</div>';
            endif;
            ?>
        </div>
        <?php
        echo $after_widget;  // WPCS: XSS OK.
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param	array	$new_instance	Values just sent to be saved.
     * @param	array	$old_instance	Previously saved values from database.
     *
     * @uses	business_shuffle_widgets_updated_field_value()		defined in widget-fields.php
     *
     * @return	array Updated safe values to be saved.
     */
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ($widget_fields as $widget_field) {

            extract($widget_field);

            // Use helper function to get updated field values
            $instance[$business_shuffle_widgets_name] = business_shuffle_widgets_updated_field_value($widget_field, $new_instance[$business_shuffle_widgets_name]);
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param	array $instance Previously saved values from database.
     *
     * @uses	business_shuffle_widgets_show_widget_field()		defined in widget-fields.php
     */
    public function form($instance) {
        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ($widget_fields as $widget_field) {

            // Make array elements available as variables
            extract($widget_field);
            $business_shuffle_widgets_field_value = !empty($instance[$business_shuffle_widgets_name]) ? esc_attr($instance[$business_shuffle_widgets_name]) : '';
            business_shuffle_widgets_show_widget_field($this, $widget_field, $business_shuffle_widgets_field_value);
        }
    }

}
