<?php

/**
 * @package Business Shuffle
 */
function business_shuffle_admin_scripts() {
    wp_enqueue_style('business-shuffle-admin-style', get_template_directory_uri() . '/inc/widgets/css/admin-style.css', array(), '1.0');
    wp_enqueue_media();
    wp_enqueue_script('business-shuffle-admin-scripts', get_template_directory_uri() . '/inc/widgets/js/admin-scripts.js', array('jquery'), '1.00', true);
}

add_action('admin_enqueue_scripts', 'business_shuffle_admin_scripts');

function business_shuffle_widgets_show_widget_field($instance = '', $widget_field = '', $business_shuffle_field_value = '') {

    extract($widget_field);

    if (isset($business_shuffle_widgets_default)) {
        $business_shuffle_field_value = !empty($business_shuffle_field_value) ? $business_shuffle_field_value : $business_shuffle_widgets_default;
    }

    switch ($business_shuffle_widgets_field_type) {

        // Standard text field
        case 'text' :
            ?>
            <p>
                <label for="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>"><?php echo esc_html($business_shuffle_widgets_title); ?>:</label>
                <input class="widefat" id="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>" name="<?php echo esc_attr($instance->get_field_name($business_shuffle_widgets_name)); ?>" type="text" value="<?php echo esc_html($business_shuffle_field_value); ?>" />

            <?php if (isset($business_shuffle_widgets_description)) { ?>
                    <br />
                    <small><?php echo wp_kses_post($business_shuffle_widgets_description); ?></small>
            <?php } ?>
            </p>
            <?php
            break;

        // Standard url field
        case 'url' :
            ?>
            <p>
                <label for="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>"><?php echo esc_html($business_shuffle_widgets_title); ?>:</label>
                <input class="widefat" id="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>" name="<?php echo esc_attr($instance->get_field_name($business_shuffle_widgets_name)); ?>" type="text" value="<?php echo esc_url($business_shuffle_field_value); ?>" />

            <?php if (isset($business_shuffle_widgets_description)) { ?>
                    <br />
                    <small><?php echo wp_kses_post($business_shuffle_widgets_description); ?></small>
            <?php } ?>
            </p>
            <?php
            break;

        // Textarea field
        case 'textarea' :
            ?>
            <p>
                <label for="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>"><?php echo esc_html($business_shuffle_widgets_title); ?>:</label>
                <textarea class="widefat" rows="<?php echo absint($business_shuffle_widgets_row); ?>" id="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>" name="<?php echo esc_attr($instance->get_field_name($business_shuffle_widgets_name)); ?>"><?php echo wp_kses_post($business_shuffle_field_value); ?></textarea>
            </p>
            <?php
            break;

        // Checkbox field
        case 'checkbox' :
            ?>
            <p>
                <input id="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>" name="<?php echo esc_attr($instance->get_field_name($business_shuffle_widgets_name)); ?>" type="checkbox" value="1" <?php checked('1', $business_shuffle_field_value); ?>/>
                <label for="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>"><?php echo esc_html($business_shuffle_widgets_title); ?></label>

            <?php if (isset($business_shuffle_widgets_description)) { ?>
                    <br />
                    <small><?php echo wp_kses_post($business_shuffle_widgets_description); ?></small>
            <?php } ?>
            </p>
            <?php
            break;

        // Radio fields
        case 'radio' :
            ?>
            <p>
                <?php
                echo esc_html($business_shuffle_widgets_title);
                echo '<br />';
                foreach ($business_shuffle_widgets_field_options as $business_shuffle_option_name => $business_shuffle_option_title) {
                    ?>
                    <input id="<?php echo esc_attr($instance->get_field_id($business_shuffle_option_name)); ?>" name="<?php echo esc_attr($instance->get_field_name($business_shuffle_widgets_name)); ?>" type="radio" value="<?php echo esc_attr($business_shuffle_option_name); ?>" <?php checked($business_shuffle_option_name, $business_shuffle_field_value); ?> />
                    <label for="<?php echo esc_attr($instance->get_field_id($business_shuffle_option_name)); ?>"><?php echo esc_html($business_shuffle_option_title); ?></label>
                    <br />
                <?php } ?>

                <?php if (isset($business_shuffle_widgets_description)) { ?>
                    <small><?php echo wp_kses_post($business_shuffle_widgets_description); ?></small>
            <?php } ?>
            </p>
            <?php
            break;

        // Select field
        case 'select' :
            ?>
            <p>
                <label for="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>"><?php echo esc_html($business_shuffle_widgets_title); ?>:</label>
                <select name="<?php echo esc_attr($instance->get_field_name($business_shuffle_widgets_name)); ?>" id="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>" class="widefat">
                    <?php foreach ($business_shuffle_widgets_field_options as $business_shuffle_option_name => $business_shuffle_option_title) { ?>
                        <option value="<?php echo esc_attr($business_shuffle_option_name); ?>" id="<?php echo esc_attr($instance->get_field_id($business_shuffle_option_name)); ?>" <?php selected($business_shuffle_option_name, $business_shuffle_field_value); ?>><?php echo esc_html($business_shuffle_option_title); ?></option>
            <?php } ?>
                </select>

            <?php if (isset($business_shuffle_widgets_description)) { ?>
                    <br />
                    <small><?php echo wp_kses_post($business_shuffle_widgets_description); ?></small>
            <?php } ?>
            </p>
            <?php
            break;

        case 'number' :
            ?>
            <p>
                <label for="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>"><?php echo esc_html($business_shuffle_widgets_title); ?>:</label><br />
                <input name="<?php echo esc_attr($instance->get_field_name($business_shuffle_widgets_name)); ?>" type="number" step="1" min="1" id="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>" value="<?php echo absint($business_shuffle_field_value); ?>" class="small-text" />

            <?php if (isset($business_shuffle_widgets_description)) { ?>
                    <br />
                    <small><?php echo wp_kses_post($business_shuffle_widgets_description); ?></small>
            <?php } ?>
            </p>
            <?php
            break;

        case 'upload':
            $image = $image_class = "";
            if ($business_shuffle_field_value) {
                $image = '<img src="' . esc_url($business_shuffle_field_value) . '" style="max-width:100%;"/>';
                $image_class = ' hidden';
            }
            ?>
            <div class="attachment-media-view">

                <label for="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>"><?php echo esc_html($business_shuffle_widgets_title); ?>:</label><br />

                <div class="placeholder<?php echo esc_attr($image_class); ?>">
            <?php esc_html_e('No image selected', 'business-shuffle'); ?>
                </div>
                <div class="thumbnail thumbnail-image">
            <?php echo $image;  // WPCS: XSS OK.  ?>
                </div>

                <div class="actions clearfix">
                    <button type="button" class="button total-delete-button align-left"><?php esc_html_e('Remove', 'business-shuffle'); ?></button>
                    <button type="button" class="button total-upload-button alignright"><?php esc_html_e('Select Image', 'business-shuffle'); ?></button>

                    <input name="<?php echo esc_attr($instance->get_field_name($business_shuffle_widgets_name)); ?>" id="<?php echo esc_attr($instance->get_field_id($business_shuffle_widgets_name)); ?>" class="upload-id" type="hidden" value="<?php echo esc_url($business_shuffle_field_value) ?>"/>
                </div>

            <?php if (isset($business_shuffle_widgets_description)) { ?>
                    <br />
                    <small><?php echo wp_kses_post($business_shuffle_widgets_description); ?></small>
            <?php } ?>

            </div>
            <?php
            break;
    }
}

function business_shuffle_widgets_updated_field_value($widget_field, $new_field_value) {

    extract($widget_field);

    // Allow only integers in number fields
    if ($business_shuffle_widgets_field_type == 'number') {
        return absint($new_field_value);
        // Allow some tags in textareas
    } elseif ($business_shuffle_widgets_field_type == 'textarea') {
        // Check if field array specifed allowed tags
        if (!isset($business_shuffle_widgets_allowed_tags)) {
            // If not, fallback to default tags
            $business_shuffle_widgets_allowed_tags = array(
                'a' => array(
                    'href' => array(),
                    'title' => array()
                ),
                'strong' => array(),
                'em' => array(),
                'p' => array()
            );
        }
        return wp_kses($new_field_value, $business_shuffle_widgets_allowed_tags);

        // No allowed tags for all other fields
    } elseif ($business_shuffle_widgets_field_type == 'url') {
        return esc_url_raw($new_field_value);
    } else {
        return wp_kses_post($new_field_value);
    }
}
