<?php
/**
 * @package Square
 */

add_action('widgets_init', 'business_shuffle_register_contact_info');

function business_shuffle_register_contact_info() {
    register_widget('business_shuffle_contact_info');
}

class business_shuffle_Contact_Info extends WP_Widget {

    public function __construct() {
        parent::__construct(
                'business_shuffle_contact_info', esc_html__('Business Shuffle - Contact Info', 'business-shuffle'), array(
                'description' => esc_html__('A widget to display Contact Information', 'business-shuffle')
                )
        );
    }

    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {
        $fields = array(
            'title' => array(
                'business_shuffle_widgets_name' => 'title',
                'business_shuffle_widgets_title' => esc_html__('Title', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'text',
            ),
            'phone' => array(
                'business_shuffle_widgets_name' => 'phone',
                'business_shuffle_widgets_title' => esc_html__('Phone', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'text',
            ),
            'contact_info_email' => array(
                'business_shuffle_widgets_name' => 'email',
                'business_shuffle_widgets_title' => esc_html__('Email', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'text',
            ),
            'website' => array(
                'business_shuffle_widgets_name' => 'website',
                'business_shuffle_widgets_title' => esc_html__('Website', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'text',
            ),
            'address' => array(
                'business_shuffle_widgets_name' => 'address',
                'business_shuffle_widgets_title' => esc_html__('Contact Address', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'textarea',
                'business_shuffle_widgets_row' => '4'
            ),
            'time' => array(
                'business_shuffle_widgets_name' => 'time',
                'business_shuffle_widgets_title' => esc_html__('Contact Time', 'business-shuffle'),
                'business_shuffle_widgets_field_type' => 'textarea',
                'business_shuffle_widgets_row' => '3'
            ),
        );

        return $fields;
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance) {
        extract($args);

        $title = isset( $instance['title'] ) ? $instance['title'] : '' ;
        $phone = isset( $instance['phone'] ) ? $instance['phone'] : '' ;
        $email = isset( $instance['email'] ) ? $instance['email'] : '' ;
        $website = isset( $instance['website'] ) ? $instance['website'] : '' ;
        $address = isset( $instance['address'] ) ? $instance['address'] : '' ;
        $time = isset( $instance['time'] ) ? $instance['time'] : '' ;

        echo $before_widget; // WPCS: XSS OK.
        ?>
        <div class="bs-contact-info">
            <?php
            if (!empty($title)):
                echo $before_title . esc_html($title) . $after_title; // WPCS: XSS OK.
            endif;
            ?>

            <ul>
                <?php if (!empty($phone)): ?>
                    <li><i class="fas fa-phone-volume"></i><?php echo wp_kses_post($phone); ?></li>
                <?php endif; ?>

                <?php if (!empty($email)): ?>
                    <li><i class="fas fa-envelope"></i><?php echo wp_kses_post($email); ?></li>
                <?php endif; ?>

                <?php if (!empty($website)): ?>
                    <li><i class="fas fa-globe"></i><?php echo wp_kses_post($website); ?></li>
                <?php endif; ?>

                <?php if (!empty($address)): ?>
                    <li><i class="fas fa-map-marker-alt"></i><?php echo wp_kses_post(wpautop($address)); ?></li>
                <?php endif; ?>

                <?php if (!empty($time)): ?>
                    <li><i class="far fa-clock"></i><?php echo wp_kses_post(wpautop($time)); ?></li>
                    <?php endif; ?>
            </ul>
        </div>
        <?php
        echo $after_widget; // WPCS: XSS OK.
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param	array	$new_instance	Values just sent to be saved.
     * @param	array	$old_instance	Previously saved values from database.
     *
     * @uses	business_shuffle_widgets_updated_field_value()		defined in widget-fields.php
     *
     * @return	array Updated safe values to be saved.
     */
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ($widget_fields as $widget_field) {

            extract($widget_field);

            // Use helper function to get updated field values
            $instance[$business_shuffle_widgets_name] = business_shuffle_widgets_updated_field_value($widget_field, $new_instance[$business_shuffle_widgets_name]);
        }

        return $instance;
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param	array $instance Previously saved values from database.
     *
     * @uses	business_shuffle_widgets_show_widget_field()		defined in widget-fields.php
     */
    public function form($instance) {
        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ($widget_fields as $widget_field) {

            // Make array elements available as variables
            extract($widget_field);
            $business_shuffle_widgets_field_value = !empty($instance[$business_shuffle_widgets_name]) ? esc_attr($instance[$business_shuffle_widgets_name]) : '';
            business_shuffle_widgets_show_widget_field($this, $widget_field, $business_shuffle_widgets_field_value);
        }
    }

}
