<?php

function business_shuffle_dynamic_style(){
    $template_color = sanitize_hex_color(get_theme_mod('business_shuffle_template_color', '#6bc56b'));
    $color_rgba = business_shuffle_hex2rgba($template_color, 0.9);
    $darker_color = business_shuffle_color_brightness($template_color, -0.9);
    
    $business_shuffle_titlebar_bg_url = esc_url(get_theme_mod('business_shuffle_titlebar_bg_url'));
    $business_shuffle_titlebar_bg_repeat = esc_attr(get_theme_mod('business_shuffle_titlebar_bg_repeat', 'no-repeat'));
    $business_shuffle_titlebar_bg_size = esc_attr(get_theme_mod('business_shuffle_titlebar_bg_size', 'cover'));
    $business_shuffle_titlebar_bg_position = get_theme_mod('business_shuffle_titlebar_bg_position', 'center-center');
    $business_shuffle_titlebar_bg_position = esc_attr(str_replace('-', ' ', $business_shuffle_titlebar_bg_position));
    $business_shuffle_titlebar_bg_attach = esc_attr(get_theme_mod('business_shuffle_titlebar_bg_attach', 'fixed'));
    $business_shuffle_titlebar_bg_color = esc_attr(get_theme_mod('business_shuffle_titlebar_bg_color', '#f7f9fd'));
    $business_shuffle_titlebar_bg_overlay = business_shuffle_sanitize_color_alpha(get_theme_mod('business_shuffle_titlebar_bg_overlay', 'rgba( 0, 0, 0, 0)'));
    $business_shuffle_titlebar_text_color = sanitize_hex_color(get_theme_mod('business_shuffle_titlebar_text_color', '#000000'));
    $business_shuffle_titlebar_padding = absint(get_theme_mod('business_shuffle_titlebar_padding', '50'));
    
    $business_shuffle_about_sidebar_width = absint(get_theme_mod('business_shuffle_about_sidebar_width', 40));
    $business_shuffle_about_content_width = absint(100 - $business_shuffle_about_sidebar_width);
    
    $business_shuffle_counter_bg = esc_url(get_theme_mod('business_shuffle_counter_bg'));
    $business_shuffle_cta_bg = esc_url(get_theme_mod('business_shuffle_cta_bg'));
    
    
    $custom_css = ".page-banner{background-image:url($business_shuffle_titlebar_bg_url);background-repeat:$business_shuffle_titlebar_bg_repeat; background-size:$business_shuffle_titlebar_bg_size; background-position:$business_shuffle_titlebar_bg_position; background-attachment: $business_shuffle_titlebar_bg_attach; background-color:$business_shuffle_titlebar_bg_color; padding-top:{$business_shuffle_titlebar_padding}px; padding-bottom: {$business_shuffle_titlebar_padding}px ; }"; 
    $custom_css .= ".page-banner:before{background:$business_shuffle_titlebar_bg_overlay}";
    $custom_css .= ".page-banner .bs-container .page-title h1{color:$business_shuffle_titlebar_text_color}";
    
    $custom_css .= "#counter-section{background-image:url($business_shuffle_counter_bg)}";
    $custom_css .= "#cta-section{background-image:url($business_shuffle_cta_bg)}";
    $custom_css .= ".about-left-content{width:{$business_shuffle_about_content_width}%}";
    $custom_css .= ".about-right-content{width:{$business_shuffle_about_sidebar_width}%}";
    
    $custom_css .= "
     a,
     a:hover, a:focus, a:active,
     .comment-list a:hover,
     .bs-menu ul ul li:hover > a,
     .bs-menu > ul > li.current-menu-item > a,
    .bs-menu > ul > li.current_page_item > a,
    .bs-menu > ul > li:hover > a,
    .highlight-block-content > i,
    .featured-icon-holder i,
    .bs-small-blog-wrap .bs-blog-excerpt .bs-blog-date,
    .bs-hentry .entry-meta,
    .widget-area a:hover,
    .single-hentry .entry-meta,
    .bs-header-search-form .search-form .search-submit,
    .counter-block > i{
       color: $template_color 
    }";
    
    $custom_css .="
    button,
    input[type='button'],
    input[type='reset'],
    input[type='submit'],
    .pagination span.current,
    .section-title.section-title-center:after,
    .bs-menu > ul > li.current-menu-item > a:after,
    .bs-menu > ul > li.current_page_item > a:after,
    .bs-main-slider.owl-carousel .owl-nav button.owl-prev:hover,
    .bs-main-slider.owl-carousel .owl-nav button.owl-next:hover,
    .bs-main-slider.owl-carousel button.owl-dot.active,
    #progressbar-section,
    .cta-section-wrap .cta-btn,
    .bs-hentry .entry-readmore a,
    .toggle-menu span{
        background:$template_color
    } 
    ";
    
    $custom_css .= "
    button,
    input[type='button'],
    input[type='reset'],
    input[type='submit'],
    .pagination span,
    .pagination a,
    .widget-area .widget-title,
    .toggle-menu,
    .counter-block{
        border-color:$template_color
    }    
    ";
    
    $custom_css .="
        .toggle-menu span{
        box-shadow: 0 10px 0 $template_color, 0 -10px 0 $template_color;
        }  
    ";
    
    return business_shuffle_css_strip_whitespace($custom_css);
}

