<?php

/* ============SLIDER IMAGES SECTION============ */
$wp_customize->add_section(new Business_shuffle_Toggle_Section($wp_customize, 'business_shuffle_slider_section', array(
    'title' => esc_html__('Home Slider', 'business-shuffle'),
    'panel' => 'business_shuffle_home_panel',
    'priority' => -1,
    'hiding_control' => 'business_shuffle_slider_disable',
)));

//ENABLE/DISABLE SLIDER
$wp_customize->add_setting('business_shuffle_slider_disable', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => 'off'
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_slider_disable', array(
    'section' => 'business_shuffle_slider_section',
    'label' => esc_html__('Disable Section', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle')
    ),
    'class' => 'switch-section',
    'priority' => -1
)));

/* Slider */
$wp_customize->add_setting('business_shuffle_slider_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_slider_heading', array(
    'section' => 'business_shuffle_slider_section',
    'label' => esc_html__('Sliders', 'business-shuffle')
)));

for( $i = 1; $i < 5; $i++ ){
    $wp_customize->add_setting('business_shuffle_slider_'.$i, array(
        'sanitize_callback' => 'absint',
    ));

    $wp_customize->add_control('business_shuffle_slider_'.$i, array(
        'section' => 'business_shuffle_slider_section',
        'type' => 'dropdown-pages',
        'label' => sprintf(esc_html__('Slider %s (Select Page)' , 'business-shuffle'), $i )
    ));
}

$wp_customize->add_setting('business_shuffle_slider_info', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Info_Text($wp_customize, 'business_shuffle_slider_info', array(
    'section' => 'business_shuffle_slider_section',
    'label' => esc_html__('Note:', 'business-shuffle'),
    'description' => esc_html__('The feature image of the page show as a slider banner. The title and content show as caption. Recommended Image Size: 1900X800 px', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_slider_setting_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_slider_setting_heading', array(
    'section' => 'business_shuffle_slider_section',
    'label' => esc_html__('Slider Settings', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_slider_full_screen', array(
    'sanitize_callback' => 'business_shuffle_sanitize_checkbox',
    'default' => false,
));

$wp_customize->add_control(new Business_shuffle_Checkbox_Control($wp_customize, 'business_shuffle_slider_full_screen', array(
    'section' => 'business_shuffle_slider_section',
    'label' => esc_html__('Full Screen Slider', 'business-shuffle'),
    'description' => esc_html__('Image may crop on either sides to cover the full screen.', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_slider_arrow', array(
    'sanitize_callback' => 'business_shuffle_sanitize_checkbox',
    'default' => true,
));

$wp_customize->add_control(new Business_shuffle_Checkbox_Control($wp_customize, 'business_shuffle_slider_arrow', array(
    'section' => 'business_shuffle_slider_section',
    'label' => esc_html__('Slider Arrow', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_slider_dots', array(
    'sanitize_callback' => 'business_shuffle_sanitize_checkbox',
    'default' => false,
));

$wp_customize->add_control(new Business_shuffle_Checkbox_Control($wp_customize, 'business_shuffle_slider_dots', array(
    'section' => 'business_shuffle_slider_section',
    'label' => esc_html__('Slider Dots', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_slider_pause', array(
    'default' => '6',
    'sanitize_callback' => 'business_shuffle_sanitize_text',
));

$wp_customize->add_control(new Business_shuffle_Range_Control($wp_customize, 'business_shuffle_slider_pause', array(
    'section' => 'business_shuffle_slider_section',
    'label' => esc_html__('Slider Pause Duration', 'business-shuffle'),
    'description' => esc_html__('Slider Pause duration in seconds', 'business-shuffle'),
    'input_attrs' => array(
        'min' => 2,
        'max' => 15,
        'step' => 1,
    )
)));