<?php

/* ============FEATURED SECTION PANEL============ */

$wp_customize->add_section(new Business_shuffle_Toggle_Section($wp_customize, 'business_shuffle_progressbar_section', array(
    'title' => esc_html__('Progress Bar Section', 'business-shuffle'),
    'panel' => 'business_shuffle_home_panel',
    'priority' => business_shuffle_get_section_position('business_shuffle_progressbar_section'),
    'hiding_control' => 'business_shuffle_progressbar_section_disable'
)));

//ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting('business_shuffle_progressbar_section_disable', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_progressbar_section_disable', array(
    'section' => 'business_shuffle_progressbar_section',
    'label' => esc_html__('Disable Section', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle'),
    ),
    'class' => 'switch-section',
    'priority' => -1,
)));

//FEATURED BLOCK
$wp_customize->add_setting('business_shuffle_progressbar_left_block_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_progressbar_left_block_heading', array(
    'section' => 'business_shuffle_progressbar_section',
    'label' => esc_html__('Left Blocks', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_progressbar_left_block_page', array(
    'sanitize_callback' => 'absint',
));

$wp_customize->add_control('business_shuffle_progressbar_left_block_page', array(
    'section' => 'business_shuffle_progressbar_section',
    'type' => 'dropdown-pages',
    'label' => esc_html__('Select a Page', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_left_block_image', array(
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control( $wp_customize, 'business_shuffle_left_block_image', array(
    'label'      => esc_html__( 'Left Block Image', 'business-shuffle' ),
    'section'    => 'business_shuffle_progressbar_section',
    ))
);    

$wp_customize->add_setting('business_shuffle_progressbar_right_block_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_progressbar_right_block_heading', array(
    'section' => 'business_shuffle_progressbar_section',
    'label' => esc_html__('Right Blocks', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_progressbar_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
));

$wp_customize->add_control('business_shuffle_progressbar_heading', array(
    'section' => 'business_shuffle_progressbar_section',
    'type' => 'text',
    'label' => esc_html__('Header', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_progressbar_sub_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
));

$wp_customize->add_control('business_shuffle_progressbar_sub_heading', array(
    'section' => 'business_shuffle_progressbar_section',
    'type' => 'text',
    'label' => esc_html__('Sub Header', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_progressbar_header', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_progressbar_header', array(
    'section' => 'business_shuffle_progressbar_section',
    'label' => esc_html__('Progress Bars', 'business-shuffle')
)));

for( $i = 1; $i < 5; $i++ ){
    
    $wp_customize->add_setting('business_shuffle_progressbar_title_'.$i, array(
        'sanitize_callback' => 'business_shuffle_sanitize_text',
    ));

    $wp_customize->add_control('business_shuffle_progressbar_title_'.$i, array(
        'section' => 'business_shuffle_progressbar_section',
        'type' => 'text',
        'label' => esc_html__('Title', 'business-shuffle')
    ));
    
    $wp_customize->add_setting('business_shuffle_progressbar_counter_'.$i, array(
        'sanitize_callback' => 'absint',
        'default' => 80,
    ));

    $wp_customize->add_control(new Business_shuffle_Range_Control($wp_customize, 'business_shuffle_progressbar_counter_'.$i, array(
        'section' => 'business_shuffle_progressbar_section',
        'label' => esc_html__('Progress Bar %', 'business-shuffle'),
        'input_attrs' => array(
            'min' => 1,
            'max' => 100,
            'step' => 1,
        )
    )));
    
    if($i != 4){
        $wp_customize->add_setting('business_shuffle_progressbar_seperator_'.$i, array(
            'sanitize_callback' => 'business_shuffle_sanitize_text'
        ));

        $wp_customize->add_control(new Business_shuffle_Separator_Control($wp_customize, 'business_shuffle_progressbar_seperator_'.$i, array(
            'section' => 'business_shuffle_progressbar_section'
        )));
    }
    
} 