<?php

/* ============CLIENTS LOGO SECTION============ */
$wp_customize->add_section(new Business_shuffle_Toggle_Section($wp_customize, 'business_shuffle_logo_section', array(
    'title' => esc_html__('Clients Logo Section', 'business-shuffle'),
    'panel' => 'business_shuffle_home_panel',
    'priority' => business_shuffle_get_section_position('business_shuffle_logo_section'),
    'hiding_control' => 'business_shuffle_logo_section_disable'
)));

//ENABLE/DISABLE LOGO SECTION
$wp_customize->add_setting('business_shuffle_logo_section_disable', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => 'off'
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_logo_section_disable', array(
    'section' => 'business_shuffle_logo_section',
    'label' => esc_html__('Disable Section', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle')
    ),
    'class' => 'switch-section',
    'priority' => -1
)));

$wp_customize->add_setting('business_shuffle_logo_title', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => esc_html__('Our Partners', 'business-shuffle'),
));

$wp_customize->add_control('business_shuffle_logo_title', array(
    'section' => 'business_shuffle_logo_section',
    'type' => 'text',
    'label' => esc_html__('Title', 'business-shuffle')
));


//CLIENTS LOGOS

$wp_customize->add_setting('business_shuffle_logos', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
));

$wp_customize->add_control(new Business_shuffle_Display_Gallery_Control($wp_customize, 'business_shuffle_logos', array(
    'section' => 'business_shuffle_logo_section',
    'label' => esc_html__('Clients Logos', 'business-shuffle')
)));