<?php

/* ============HIGHLIGHT SECTION PANEL============ */
$wp_customize->add_section(new Business_shuffle_Toggle_Section($wp_customize, 'business_shuffle_highlight_section', array(
    'title' => esc_html__('Highlight Section', 'business-shuffle'),
    'panel' => 'business_shuffle_home_panel',
    'priority' => business_shuffle_get_section_position('business_shuffle_highlight_section'),
    'hiding_control' => 'business_shuffle_highlight_section_disable'
)));

//ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting('business_shuffle_highlight_section_disable', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_highlight_section_disable', array(
    'section' => 'business_shuffle_highlight_section',
    'label' => esc_html__('Disable Section', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle')
    ),
    'class' => 'switch-section',
    'priority' => -1
)));


//HIGHLIGHT BLOCK

$wp_customize->add_setting('business_shuffle_highlight_block_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_highlight_block_heading', array(
    'section' => 'business_shuffle_highlight_section',
    'label' => esc_html__('Highlight Blocks', 'business-shuffle')
)));

for( $i = 1; $i < 4; $i++ ){
    
    $wp_customize->add_setting('business_shuffle_highlight_icon_'.$i, array(
        'default' => 'fas fa-address-book',
        'sanitize_callback' => 'business_shuffle_sanitize_text'
    ));

    $wp_customize->add_control(new Business_shuffle_Fontawesome_Icon_Chooser($wp_customize, 'business_shuffle_highlight_icon_'.$i, array(
        'section' => 'business_shuffle_highlight_section',
        'label' => esc_html__('Highlight Blocks Icon', 'business-shuffle'),
        'type' => 'text'
    )));
    
    $wp_customize->add_setting('business_shuffle_highlight_title_'.$i, array(
        'sanitize_callback' => 'business_shuffle_sanitize_text',
    ));

    $wp_customize->add_control('business_shuffle_highlight_title_'.$i, array(
        'section' => 'business_shuffle_highlight_section',
        'type' => 'text',
        'label' => esc_html__('Title', 'business-shuffle')
    ));
    
    $wp_customize->add_setting('business_shuffle_highlight_link_'.$i, array(
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control('business_shuffle_highlight_link_'.$i, array(
        'section' => 'business_shuffle_highlight_section',
        'type' => 'url',
        'label' => esc_html__('Read More Link', 'business-shuffle')
    ));
    
    $wp_customize->add_setting('business_shuffle_highlight_bg_'.$i, array(
        'sanitize_callback' => 'esc_url_raw',
    ));
    
    $wp_customize->add_control(new WP_Customize_Image_Control( $wp_customize, 'business_shuffle_highlight_bg_'.$i, array(
        'label'      => esc_html__( 'Background Image', 'business-shuffle' ),
        'section'    => 'business_shuffle_highlight_section',
        ))
    );
    
    if($i != 3){
        $wp_customize->add_setting('business_shuffle_highlight_seperator_'.$i, array(
            'sanitize_callback' => 'business_shuffle_sanitize_text'
        ));

        $wp_customize->add_control(new Business_shuffle_Separator_Control($wp_customize, 'business_shuffle_highlight_seperator_'.$i, array(
            'section' => 'business_shuffle_highlight_section'
        )));
    }
}