<?php

/* ============FEATURED SECTION PANEL============ */

$wp_customize->add_section(new Business_shuffle_Toggle_Section($wp_customize, 'business_shuffle_featured_section', array(
    'title' => esc_html__('Featured Section', 'business-shuffle'),
    'panel' => 'business_shuffle_home_panel',
    'priority' => business_shuffle_get_section_position('business_shuffle_featured_section'),
    'hiding_control' => 'business_shuffle_featured_section_disable'
)));

//ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting('business_shuffle_featured_section_disable', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_featured_section_disable', array(
    'section' => 'business_shuffle_featured_section',
    'label' => esc_html__('Disable Section', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle'),
    ),
    'class' => 'switch-section',
    'priority' => -1,
)));

$wp_customize->add_setting('business_shuffle_featured_title', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => esc_html__('Featured Section', 'business-shuffle'),
));

$wp_customize->add_control('business_shuffle_featured_title', array(
    'section' => 'business_shuffle_featured_section',
    'type' => 'text',
    'label' => esc_html__('Title', 'business-shuffle')
));

//FEATURED BLOCK
$wp_customize->add_setting('business_shuffle_featured_block_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_featured_block_heading', array(
    'section' => 'business_shuffle_featured_section',
    'label' => esc_html__('Featured Blocks', 'business-shuffle')
)));

for( $i = 1; $i < 7; $i++ ){
    $wp_customize->add_setting('business_shuffle_featured_icon_'.$i, array(
        'default' => 'fas fa-address-book',
        'sanitize_callback' => 'business_shuffle_sanitize_text'
    ));

    $wp_customize->add_control(new Business_shuffle_Fontawesome_Icon_Chooser($wp_customize, 'business_shuffle_featured_icon_'.$i, array(
        'section' => 'business_shuffle_featured_section',
        'label' => esc_html__('Featured Blocks Icon', 'business-shuffle'),
        'type' => 'text'
    )));
    
    $wp_customize->add_setting('business_shuffle_featured_'.$i, array(
        'sanitize_callback' => 'absint',
    ));

    $wp_customize->add_control('business_shuffle_featured_'.$i, array(
        'section' => 'business_shuffle_featured_section',
        'type' => 'dropdown-pages',
        'label' => sprintf(esc_html__('Featured %s (Select Page)' , 'business-shuffle'), $i )
    ));
    
    if($i != 6){
        $wp_customize->add_setting('business_shuffle_featured_seperator_'.$i, array(
            'sanitize_callback' => 'business_shuffle_sanitize_text'
        ));

        $wp_customize->add_control(new Business_shuffle_Separator_Control($wp_customize, 'business_shuffle_featured_seperator_'.$i, array(
            'section' => 'business_shuffle_featured_section'
        )));
    }
}

$wp_customize->add_setting('business_shuffle_featured_info', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Info_Text($wp_customize, 'business_shuffle_featured_info', array(
    'section' => 'business_shuffle_featured_section',
    'label' => esc_html__('Note:', 'business-shuffle'),
    'description' => esc_html__('Add Excerpt in the page if you want to display the whole text.', 'business-shuffle')
)));


$wp_customize->add_setting('business_shuffle_featured_setting_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_featured_setting_heading', array(
    'section' => 'business_shuffle_featured_section',
    'label' => esc_html__('Settings', 'business-shuffle')
)));


$wp_customize->add_setting('business_shuffle_featured_col', array(
    'sanitize_callback' => 'absint',
    'default' => 3,
));

$wp_customize->add_control(new Business_shuffle_Range_Control($wp_customize, 'business_shuffle_featured_col', array(
    'section' => 'business_shuffle_featured_section',
    'label' => esc_html__('No of Columns', 'business-shuffle'),
    'input_attrs' => array(
        'min' => 2,
        'max' => 6,
        'step' => 1,
    )
)));

$wp_customize->add_setting('business_shuffle_featured_link_to_detail', array(
    'sanitize_callback' => 'business_shuffle_sanitize_checkbox',
    'default' => false,
));

$wp_customize->add_control(new Business_shuffle_Checkbox_Control($wp_customize, 'business_shuffle_featured_link_to_detail', array(
    'section' => 'business_shuffle_featured_section',
    'label' => esc_html__('Link to Detail Page', 'business-shuffle'),
    'description' => esc_html__('Read More button will show.', 'business-shuffle')
)));