<?php

/* ============CALL TO ACTION PANEL============ */
$wp_customize->add_section(new Business_shuffle_Toggle_Section($wp_customize, 'business_shuffle_cta_section', array(
    'title' => esc_html__('Call To Action Section', 'business-shuffle'),
    'panel' => 'business_shuffle_home_panel',
    'priority' => business_shuffle_get_section_position('business_shuffle_cta_section'),
    'hiding_control' => 'business_shuffle_cta_section_disable'
)));

//ENABLE/DISABLE LOGO SECTION
$wp_customize->add_setting('business_shuffle_cta_section_disable', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => 'off'
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_cta_section_disable', array(
    'section' => 'business_shuffle_cta_section',
    'label' => esc_html__('Disable Section', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle')
    ),
    'class' => 'switch-section',
    'priority' => -1
)));

$wp_customize->add_setting('business_shuffle_cta_title', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => esc_html__('Call To Action Section', 'business-shuffle'),
));

$wp_customize->add_control('business_shuffle_cta_title', array(
    'section' => 'business_shuffle_cta_section',
    'type' => 'text',
    'label' => esc_html__('Title', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_cta_sub_title', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => esc_html__('Call To Action Section SubTitle', 'business-shuffle'),
));

$wp_customize->add_control('business_shuffle_cta_sub_title', array(
    'section' => 'business_shuffle_cta_section',
    'type' => 'textarea',
    'label' => esc_html__('Sub Title', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_cta_button1_text', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
));

$wp_customize->add_control('business_shuffle_cta_button1_text', array(
    'section' => 'business_shuffle_cta_section',
    'type' => 'text',
    'label' => esc_html__('Button 1 Text', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_cta_button1_link', array(
    'default' => '',
    'sanitize_callback' => 'business_shuffle_sanitize_text',
));

$wp_customize->add_control('business_shuffle_cta_button1_link', array(
    'section' => 'business_shuffle_cta_section',
    'type' => 'url',
    'label' => esc_html__('Button 1 Link', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_cta_button2_text', array(
    'default' => '',
    'sanitize_callback' => 'business_shuffle_sanitize_text',
));

$wp_customize->add_control('business_shuffle_cta_button2_text', array(
    'section' => 'business_shuffle_cta_section',
    'type' => 'text',
    'label' => esc_html__('Button 2 Text', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_cta_button2_link', array(
    'default' => '',
    'sanitize_callback' => 'business_shuffle_sanitize_text',
));

$wp_customize->add_control('business_shuffle_cta_button2_link', array(
    'section' => 'business_shuffle_cta_section',
    'type' => 'url',
    'label' => esc_html__('Button 2 Link', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_cta_bg', array(
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control( $wp_customize, 'business_shuffle_cta_bg', array(
    'label'      => esc_html__( 'CTA Background Image', 'business-shuffle' ),
    'section'    => 'business_shuffle_cta_section',
    ))
);  