<?php

/* ============COUNTER SECTION PANEL============ */
$wp_customize->add_section(new Business_shuffle_Toggle_Section($wp_customize, 'business_shuffle_counter_section', array(
    'title' => esc_html__('Counter Section', 'business-shuffle'),
    'panel' => 'business_shuffle_home_panel',
    'priority' => business_shuffle_get_section_position('business_shuffle_counter_section'),
    'hiding_control' => 'business_shuffle_counter_section_disable'
)));

//ENABLE/DISABLE COUNTER SECTION
$wp_customize->add_setting('business_shuffle_counter_section_disable', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => 'off'
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_counter_section_disable', array(
    'section' => 'business_shuffle_counter_section',
    'label' => esc_html__('Disable Section', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle')
    ),
    'class' => 'switch-section',
    'priority' => -1
)));

$wp_customize->add_setting('business_shuffle_counter_title', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => esc_html__('Our Stats', 'business-shuffle'),
));

$wp_customize->add_control('business_shuffle_counter_title', array(
    'section' => 'business_shuffle_counter_section',
    'type' => 'text',
    'label' => esc_html__('Title', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_counter_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_counter_heading', array(
    'section' => 'business_shuffle_counter_section',
    'label' => esc_html__('Counters', 'business-shuffle')
)));

for ($i = 1; $i < 5; $i++) {

    $wp_customize->add_setting('business_shuffle_counter_icon_' . $i, array(
        'default' => 'fas fa-address-book',
        'sanitize_callback' => 'business_shuffle_sanitize_text'
    ));

    $wp_customize->add_control(new Business_shuffle_Fontawesome_Icon_Chooser($wp_customize, 'business_shuffle_counter_icon_' . $i, array(
        'section' => 'business_shuffle_counter_section',
        'label' => esc_html__('Counter Blocks Icon', 'business-shuffle'),
        'type' => 'text'
    )));

    $wp_customize->add_setting('business_shuffle_counter_title_' . $i, array(
        'sanitize_callback' => 'business_shuffle_sanitize_text',
    ));

    $wp_customize->add_control('business_shuffle_counter_title_' . $i, array(
        'section' => 'business_shuffle_counter_section',
        'type' => 'text',
        'label' => esc_html__('Title', 'business-shuffle')
    ));

    $wp_customize->add_setting('business_shuffle_counter_' . $i, array(
        'sanitize_callback' => 'absint',
    ));

    $wp_customize->add_control('business_shuffle_counter_' . $i, array(
        'section' => 'business_shuffle_counter_section',
        'type' => 'number',
        'label' => esc_html__('Counter', 'business-shuffle')
    ));

    if ($i != 4) {
        $wp_customize->add_setting('business_shuffle_counter_seperator_' . $i, array(
            'sanitize_callback' => 'business_shuffle_sanitize_text'
        ));

        $wp_customize->add_control(new Business_shuffle_Separator_Control($wp_customize, 'business_shuffle_counter_seperator_' . $i, array(
            'section' => 'business_shuffle_counter_section'
        )));
    }
}

$wp_customize->add_setting('business_shuffle_counter_setting_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_counter_setting_heading', array(
    'section' => 'business_shuffle_counter_section',
    'label' => esc_html__('Settings', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_counter_col', array(
    'sanitize_callback' => 'absint',
    'default' => 4,
));

$wp_customize->add_control(new Business_shuffle_Range_Control($wp_customize, 'business_shuffle_counter_col', array(
    'section' => 'business_shuffle_counter_section',
    'label' => esc_html__('No of Columns', 'business-shuffle'),
    'input_attrs' => array(
        'min' => 2,
        'max' => 4,
        'step' => 1,
    )
)));

$wp_customize->add_setting('business_shuffle_counter_bg', array(
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'business_shuffle_counter_bg', array(
    'label' => __('Counter Background Image', 'business-shuffle'),
    'section' => 'business_shuffle_counter_section',
        ))
);
