<?php

/* ============BLOG PANEL============ */
$wp_customize->add_section(new Business_shuffle_Toggle_Section($wp_customize, 'business_shuffle_blog_section', array(
    'title' => esc_html__('Blog Section', 'business-shuffle'),
    'panel' => 'business_shuffle_home_panel',
    'priority' => business_shuffle_get_section_position('business_shuffle_blog_section'),
    'hiding_control' => 'business_shuffle_blog_section_disable'
)));

//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting('business_shuffle_blog_section_disable', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => 'off'
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_blog_section_disable', array(
    'section' => 'business_shuffle_blog_section',
    'label' => esc_html__('Disable Section', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle')
    ),
    'class' => 'switch-section',
    'priority' => -1
)));

$wp_customize->add_setting('business_shuffle_blog_title', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => esc_html__('Latest News', 'business-shuffle'),
));

$wp_customize->add_control('business_shuffle_blog_title', array(
    'section' => 'business_shuffle_blog_section',
    'type' => 'text',
    'label' => esc_html__('Title', 'business-shuffle')
));

//BLOG SETTINGS
$wp_customize->add_setting('business_shuffle_blog_setting_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_blog_setting_heading', array(
    'section' => 'business_shuffle_blog_section',
    'label' => esc_html__('Settings', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_blog_cat_exclude', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
));

$wp_customize->add_control(new Business_shuffle_Customize_Checkbox_Multiple($wp_customize, 'business_shuffle_blog_cat_exclude', array(
    'label' => esc_html__('Exclude Category from Blog Posts', 'business-shuffle'),
    'section' => 'business_shuffle_blog_section',
    'choices' => $business_shuffle_cat
)));