<?php

/* ============ABOUT US SECTION============ */
$wp_customize->add_section(new Business_shuffle_Toggle_Section($wp_customize, 'business_shuffle_about_section', array(
    'title' => esc_html__('About Us Section', 'business-shuffle'),
    'panel' => 'business_shuffle_home_panel',
    'priority' => business_shuffle_get_section_position('business_shuffle_about_section'),
    'hiding_control' => 'business_shuffle_about_page_disable'
)));

//ENABLE/DISABLE ABOUT US PAGE
$wp_customize->add_setting('business_shuffle_about_page_disable', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => 'off'
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_about_page_disable', array(
    'section' => 'business_shuffle_about_section',
    'label' => esc_html__('Disable Section', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle')
    ),
    'class' => 'switch-section',
    'priority' => -1,
)));

$wp_customize->add_setting('business_shuffle_about_page_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_about_page_heading', array(
    'section' => 'business_shuffle_about_section',
    'label' => esc_html__('About Page - Left Block', 'business-shuffle')
)));

//ABOUT US PAGE
$wp_customize->add_setting('business_shuffle_about_page', array(
    'sanitize_callback' => 'absint',
));

$wp_customize->add_control('business_shuffle_about_page', array(
    'section' => 'business_shuffle_about_section',
    'type' => 'dropdown-pages',
    'label' => esc_html__('Select a Page', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_about_sidebar_heading', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text'
));

$wp_customize->add_control(new Business_shuffle_Customize_Heading($wp_customize, 'business_shuffle_about_sidebar_heading', array(
    'section' => 'business_shuffle_about_section',
    'label' => esc_html__('Sidebar - Right Block', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_disable_about_sidebar', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => 'off',
));

$wp_customize->add_control(new Business_shuffle_Switch_Control($wp_customize, 'business_shuffle_disable_about_sidebar', array(
    'section' => 'business_shuffle_about_section',
    'label' => esc_html__('Disable Sidebar', 'business-shuffle'),
    'description' => esc_html__('If disabled, the left content will cover the full width', 'business-shuffle'),
    'on_off_label' => array(
        'on' => esc_html__('Yes', 'business-shuffle'),
        'off' => esc_html__('No', 'business-shuffle')
    )
)));

$wp_customize->add_setting('business_shuffle_about_sidebar_width', array(
    'sanitize_callback' => 'absint',
    'default' => 40,
));

$wp_customize->add_control(new Business_shuffle_Range_Control($wp_customize, 'business_shuffle_about_sidebar_width', array(
    'section' => 'business_shuffle_about_section',
    'label' => esc_html__('Sidebar Width', 'business-shuffle'),
    'input_attrs' => array(
        'min' => 10,
        'max' => 100,
        'step' => 1
    )
)));

$wp_customize->add_setting('business_shuffle_about_sidebar', array(
    'default' => 'single-image',
    'sanitize_callback' => 'business_shuffle_sanitize_choices',
));

$wp_customize->add_control('business_shuffle_about_sidebar', array(
    'section' => 'business_shuffle_about_section',
    'type' => 'select',
    'label' => esc_html__('Choose Content to Display', 'business-shuffle'),
    'choices' => array(
        'single-image' => esc_html__('Single Image', 'business-shuffle'),
        'widget' => esc_html__('Widget', 'business-shuffle')
    )
));

$wp_customize->add_setting('business_shuffle_about_image', array(
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'business_shuffle_about_image', array(
    'section' => 'business_shuffle_about_section',
    'label' => esc_html__('Upload Image', 'business-shuffle'),
    'description' => esc_html__('Recommended Image Size: 500X600px', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_about_widget', array(
    'default' => '0',
    'sanitize_callback' => 'business_shuffle_sanitize_choices',
));

$wp_customize->add_control('business_shuffle_about_widget', array(
    'section' => 'business_shuffle_about_section',
    'type' => 'select',
    'label' => esc_html__('Replace Image by widget', 'business-shuffle'),
    'choices' => $business_shuffle_widget_list
));