<?php

/**
 * Business Shuffle Theme Customizer
 *
 * @package Business Shuffle
 */
/* HEADER PANEL */
$wp_customize->add_panel('business_shuffle_header_settings_panel', array(
    'title' => esc_html__('Header Settings', 'business-shuffle'),
    'priority' => 15
));

$wp_customize->get_section('title_tagline')->panel = 'business_shuffle_header_settings_panel';
$wp_customize->get_section('title_tagline')->title = esc_html__('Logo & Favicon', 'business-shuffle');

$wp_customize->add_setting('business_shuffle_hide_title', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => false,
));

$wp_customize->add_control('business_shuffle_hide_title', array(
    'type' => 'checkbox',
    'section' => 'title_tagline',
    'label' => esc_html__('Hide Site Title', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_hide_tagline', array(
    'sanitize_callback' => 'business_shuffle_sanitize_text',
    'default' => false,
));

$wp_customize->add_control('business_shuffle_hide_tagline', array(
    'type' => 'checkbox',
    'section' => 'title_tagline',
    'label' => esc_html__('Hide Site Tagline', 'business-shuffle')
));

//TITLE BAR SETTINGS
$wp_customize->add_section('business_shuffle_titlebar_section', array(
    'title' => esc_html__('Title Bar Settings', 'business-shuffle'),
    'panel' => 'business_shuffle_header_settings_panel',
    'description' => esc_html__('This setting will apply in all post, pages, archive, search pages', 'business-shuffle')
));

$wp_customize->add_setting('business_shuffle_titlebar_bg_url', array(
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_setting('business_shuffle_titlebar_bg_id', array(
    'sanitize_callback' => 'absint',
));

$wp_customize->add_setting('business_shuffle_titlebar_bg_repeat', array(
    'default' => 'no-repeat',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_setting('business_shuffle_titlebar_bg_size', array(
    'default' => 'cover',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_setting('business_shuffle_titlebar_bg_position', array(
    'default' => 'center-center',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_setting('business_shuffle_titlebar_bg_attach', array(
    'default' => 'fixed',
    'sanitize_callback' => 'sanitize_text_field',
));

// Registers example_background control
$wp_customize->add_control(new Business_shuffle_Background_Control($wp_customize, 'business_shuffle_titlebar_bg', array(
    'label' => esc_html__('Title Bar Background', 'business-shuffle'),
    'section' => 'business_shuffle_titlebar_section',
    'settings' => array(
        'image_url' => 'business_shuffle_titlebar_bg_url',
        'image_id' => 'business_shuffle_titlebar_bg_id',
        'repeat' => 'business_shuffle_titlebar_bg_repeat',
        'size' => 'business_shuffle_titlebar_bg_size',
        'position' => 'business_shuffle_titlebar_bg_position',
        'attach' => 'business_shuffle_titlebar_bg_attach'
    )
)));

$wp_customize->add_setting('business_shuffle_titlebar_bg_color', array(
    'default' => '#f7f9fd',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'business_shuffle_titlebar_bg_color', array(
    'section' => 'business_shuffle_titlebar_section',
    'label' => esc_html__('Background Color', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_titlebar_bg_overlay', array(
    'default' => 'rgba( 0, 0, 0, 0)',
    'sanitize_callback' => 'business_shuffle_sanitize_color_alpha',
));

$wp_customize->add_control(new Business_shuffle_Alpha_Color_Control($wp_customize, 'business_shuffle_titlebar_bg_overlay', array(
    'label' => esc_html__('Header Background Overlay Color', 'business-shuffle'),
    'section' => 'business_shuffle_titlebar_section',
    'palette' => array(
        '#FFFFFF',
        '#000000',
        '#f5245f',
        '#1267b3',
        '#feb600',
        '#00C569',
        'rgba( 255, 255, 255, 0.2 )',
        'rgba( 0, 0, 0, 0.2 )'
    )
)));

$wp_customize->add_setting('business_shuffle_titlebar_text_color', array(
    'default' => '#333333',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'business_shuffle_titlebar_text_color', array(
    'section' => 'business_shuffle_titlebar_section',
    'label' => esc_html__('Text Color', 'business-shuffle')
)));

$wp_customize->add_setting('business_shuffle_titlebar_padding', array(
    'sanitize_callback' => 'absint',
    'default' => 50,
));

$wp_customize->add_control(new Business_shuffle_Range_Control($wp_customize, 'business_shuffle_titlebar_padding', array(
    'section' => 'business_shuffle_titlebar_section',
    'label' => esc_html__('Top & Bottom Padding', 'business-shuffle'),
    'input_attrs' => array(
        'min' => 0,
        'max' => 200,
        'step' => 1
    )
)));