<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Business_Shuffle
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="https://gmpg.org/xfn/11">

        <?php wp_head(); ?>
    </head>

    <body <?php body_class(); ?>>
        <?php wp_body_open(); ?>

        <a href="#content" class="skip-content-link" tabindex="1"><?php esc_html_e('Skip to content', 'business-shuffle'); ?></a>
        <div id="page" class="site">

            <header id="masthead" class="site-header bs-site-header">
                <div class="bs-container">
                    <div class="site-branding">
                        <?php
                        $business_shuffle_hide_title = get_theme_mod('business_shuffle_hide_title', false);
                        $business_shuffle_hide_tagline = get_theme_mod('business_shuffle_hide_tagline', false);

                        the_custom_logo();

                        if (!$business_shuffle_hide_title) {
                            if (is_front_page() && is_home()) :
                                ?>
                                <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                <?php
                            else :
                                ?>
                                <p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></p>
                            <?php
                            endif;
                        }

                        if (!$business_shuffle_hide_tagline) {
                            $business_shuffle_description = get_bloginfo('description', 'display');
                            if ($business_shuffle_description || is_customize_preview()) :
                                ?>
                                <p class="site-description"><?php echo $business_shuffle_description; /* WPCS: xss ok. */ ?></p>
                                <?php
                            endif;
                        }
                        ?>
                    </div><!-- .site-branding -->


                    <nav id="site-navigation" class="bs-navigation main-navigation">
                        <div class="toggle-menu"><span></span></div>
                        <?php
                        wp_nav_menu(array(
                            'theme_location' => 'business-shuffle-menu',
                            'container_class' => 'bs-menu',
                            'menu_class' => 'clearfix',
                            'fallback_cb' => false
                        ));
                        ?>
                    </nav><!-- #site-navigation -->
                </div>
                <?php
                $enable_search = get_theme_mod('business_shuffle_mh_show_search', false);
                if ($enable_search) {
                    ?>
                    <div class="bs-header-search-form">
                        <div class="bs-header-close"></div>
                        <?php echo get_search_form(); ?>
                    </div>
                <?php } ?>
            </header><!-- #masthead -->

            <div id="content" class="site-content" tabindex="-1">
