<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Business_Shuffle
 */
?>

</div><!-- #content -->

<footer id="colophon" class="site-footer bs-site-footer">
    <div class="top-footer">
        <div class="bs-container">
            <div class="top-footer-wrap clearfix">
                <?php for ($i = 1; $i <= 4; $i++) { ?>
                    <div class="bs-footer bs-footer<?php echo absint($i); ?>">
                        <?php
                        if (is_active_sidebar('business-shuffle-footer' . $i)):
                            dynamic_sidebar('business-shuffle-footer' . $i);
                        endif;
                        ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>

    <div class="bottom-footer">
        <div class="bs-container">
            <div class="copyright">
                <?php printf(esc_html__('Design&Developed by', 'business-shuffle')); ?>
                <span class="sep"> | </span>
                <?php
                printf(
                        // translators: 1-Theme URL, 2-Theme Author
                        esc_html__('%1$s %2$s', 'business-shuffle'), '<a href="https://inrankmarketing.com/" target="_blank">Inrank Marketing</a>', '');
                ?></div>
        </div>
    </div>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
